<?php
namespace lib;

Lang::load('form');

class Form
{
	public $name, $valid, $submitted, $fields, $bulk, $request, $preset;
	private $method, $multipart;
	
	public static $form_id = 0;
	
	public function __construct($name, $preset='default', $pseudo=false, $method='POST')
	{
		$this->name = $name;
		$this->preset = $preset;
		$this->bulk = $pseudo?0:static::$form_id++;
		$this->method = strtoupper($method);
		$this->multipart = false;
		
		$this->fields = array();
		
		if($this->method == 'POST')
		{
			$this->request = $_POST;
		} elseif($this->method == 'GET')
		{
			$this->request = $_GET;
		} else
		{
			$this->request = array();
		}
		
		$this->submitted = isset($this->request[$name]) && $this->request[$name] == '1';
	}
	
	public function request($key)
	{
		if(!isset($this->request[$key]))
		{
			return null;
		}
		
		if(is_array($this->request[$key]))
		{
			return isset($this->request[$key][$this->bulk])?$this->request[$key][$this->bulk]:null;
		} else
		{
			return $this->request[$key];
		}
	}
	
	# Fields
	public function field($name, $type='text')
	{
		$args = func_get_args();
		
		if($type == 'password' || $type == 'text')
		{
			$args[1] = $type == 'password';
			
			$type = 'text';
		} else
		{
			unset($args[1]);
		}
		
		$rc = new \ReflectionClass('\\lib\\Field\\'.$type);
		
		$this->fields[$name] = $rc->newInstanceArgs($args);
		
		$this->fields[$name]->child_of($this);
	}
	
	public function __get($name)
	{
		if(isset($this->fields[$name]))
		{
			return $this->fields[$name];
		} else
		{
			return null;
		}
	}
	
	# Validate
	public function validate()
	{
		if(!$this->submitted)
		{
			return $this->valid = false;
		}
		
		$this->valid = true;
		
		foreach($this->fields as $name=>$field)
		{
			if(!$this->fields[$name]->validate())
			{
				$this->valid = false;
			}
		}
		
		return $this->valid;
	}
	
	# Errors
	public function errors()
	{
		$errors = array();
		
		foreach($this->fields as $name=>$field)
		{
			if($this->fields[$name]->error_message)
			{
				$errors[$name] = $this->fields[$name]->error_message;
			}
		}
		
		return $errors;
	}
	
	# HTML
	public function multipart()
	{
		$this->multipart = true;
		
		$this->request = array_merge($this->request, $_FILES);
	}
	
	public function open()
	{
		return '<form'.($this->multipart?' enctype="multipart/form-data"':'').' action="'.WEB.(defined('MOD_REWRITE')?'':'/index.php?p=').ROUTE.'" name="'.$this->name.'" method="'.$this->method.'"><input type="hidden" name="'.$this->name.'" value="1"/>';
	}
	
	public function close()
	{
		return '</form>';
	}
	
	public function submit()
	{
		return '<input class="button" type="submit" value="'.$this->submit_text().'"/>';
	}
	
	public function submit_text()
	{
		return \lib\Lang::get($this->name, 'submit');
	}
	
	# Hide
	public function hide()
	{
		static::$form_id--;
	}
}